package race.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

import race.Operation;

/**
 * This implementation of {@link Operation} interface executes the sorting of an
 * {@link ArrayList} of integer elements using the well-known bubble sort
 * algorithm
 * 
 * @author simone
 * @version 1.1
 * @see Operation
 *
 */
public class ArrayListSortingWithBubbleSort implements Operation {

	private ArrayList<Integer> data;

	@Override
	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "Sorting of an ArrayList<Integer> using bubble sort algorithm"+" [executed over "+data.size()+" elements]";
	}

	@Override
	/*
	 * (non-Javadoc)
	 * @see contest.Operation#operate()
	 */
	public void operate() {
		int listSize = data.size();
		for (int i = 0; i < listSize; i++) {
			for (int j = 0; j < data.size(); j++) {
				if (data.get(i) > data.get(j)) {
					int tmp = data.get(i);
					data.add(i, data.get(j));
					data.add(j, tmp);
				}
			}
		}
	}

	@Override
	/*
	 * (non-Javadoc)
	 * @see contest.Operation#initializeOperationData(java.util.ArrayList)
	 */
	public void initializeOperationData(ArrayList<Integer> randomSeem) {
		this.data = randomSeem;
	}

}
